<?php

namespace App\Controllers;

use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;
use App\Classes\Email;
use App\Traits\RespondsWithJson;
use Psr\Log\LoggerInterface;
use InvalidArgumentException;

class FormEmailController
{
    use RespondsWithJson;
    
    public function __construct(
        protected LoggerInterface $logger,
        protected Email $email
    ) {}

    public function create(Request $request, Response $response): Response
    {
        try {
            $componentConfig = requireBackendFile($request, 'config.php');
            $this->validateConfig($componentConfig);

            $data = $request->getParsedBody();
            $files = $request->getUploadedFiles();

            $result = $this->email->send($componentConfig, $data, $files);

            return $this->jsonResponse(
                $response, 
                ['success' => $result['success']]
            );

        } catch (\Exception $e) {
            return $this->errorResponse(
                $response, 
                $e->getMessage(), 
                500
            );
        }
    }

    private function validateConfig(array $config): void
    {
        if (empty($config['email'])) {
            throw new InvalidArgumentException("No email configuration found for component");
        }

        // check if all required fields are present by looping through the following array
        $requiredFields = ['host', 'port', 'smtp_secure', 'username', 'password', 'subject', 'to_name', 'to_address'];
        foreach ($requiredFields as $field) {
            if (!isset($config['email'][$field])) {
                throw new InvalidArgumentException("Missing required configuration field: {$field}");
            }
        }
    }
} 