document.addEventListener("alpine:init", () => {
    Alpine.data("vimeo", (id = "", options = {}) => ({
        id,
        options: {
            muted: false,
            autoplay: false,
            controls: true,
            loop: false,
            ...options,
        },
        player: null,
        isPlaying: false,

        init() {
            this.player = new Vimeo.Player(
                document.getElementById(`vimeo-player-${this.id}`),
                {
                    url: `https://vimeo.com/${this.id}`,
                    loop: this.options.loop,
                    autoplay: this.options.autoplay,
                    muted: this.options.muted,
                    controls: this.options.controls,
                }
            );

            this.player.on("play", () => {
                this.isPlaying = true;
            });

            this.player.on("pause", () => {
                this.isPlaying = false;
            });
        },

        createPlayer() {
            document.addEventListener("DOMContentLoaded", function () {
                vimeoPlayer().init();
            });
        },
    }));
});
