document.addEventListener("alpine:init", () => {
    Alpine.data("youtube", (id = "", options = {}) => ({
        id,
        options: {
            muted: false,
            autoplay: false,
            controls: true,
            loop: false,
            ...options,
        },
        player: null,
        isPlaying: false,

        init() {
            if (typeof YT === "undefined") {
                var tag = document.createElement("script");
                tag.src = "https://www.youtube.com/iframe_api";
                var firstScriptTag = document.getElementsByTagName("script")[0];
                firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
            }
            this.createPlayer();
        },

        createPlayer() {
            window.onYouTubeIframeAPIReady = () => {
                this.player = new YT.Player("player", {
                    videoId: this.id,
                    playerVars: {
                        playsinline: 1,
                        autoplay: this.options.autoplay,
                        controls: this.options.controls,
                        loop: this.options.loop,
                        playlist: this.id,
                    },
                    events: {
                        onReady: (event) => this.onPlayerReady(event),
                        onStateChange: (event) =>
                            this.onPlayerStateChange(event),
                    },
                });
            };
        },

        onPlayerReady() {
            if (this.options.muted) {
                this.player.mute();
            }
            if (this.options.autoplay) {
                this.startPlaying();
            }
        },

        onPlayerStateChange(event) {
            if (event.data === YT.PlayerState.PLAYING) {
                this.isPlaying = true;
            }
        },

        startPlaying() {
            this.player.playVideo();
        },
    }));
});
