<?php

namespace App\Handlers;

use Psr\Http\Message\ResponseInterface;
use Slim\Handlers\ErrorHandler;
use InvalidArgumentException;
use RuntimeException;
use LogicException;

class HttpErrorHandler extends ErrorHandler
{
    protected function respond(): ResponseInterface
    {
        $exception = $this->exception;
        $statusCode = 500;
        $error = 'Internal Server Error';

        // Map common exceptions to HTTP status codes
        if ($exception instanceof InvalidArgumentException) {
            $statusCode = 400; // Bad Request
            $error = $exception->getMessage();
        } elseif ($exception instanceof RuntimeException) {
            $statusCode = 422; // Unprocessable Entity
            $error = $exception->getMessage();
        } elseif ($exception instanceof LogicException) {
            $statusCode = 409; // Conflict
            $error = $exception->getMessage();
        }

        $payload = [
            'success' => false,
            'error' => $error
        ];

        if ($this->displayErrorDetails) {
            $payload['trace'] = [
                'file' => $exception->getFile(),
                'line' => $exception->getLine(),
                'message' => $exception->getMessage(),
                'trace' => $exception->getTrace()
            ];
        }

        $response = $this->responseFactory->createResponse($statusCode);
        $response->getBody()->write(json_encode($payload, JSON_PRETTY_PRINT));

        return $response->withHeader('Content-Type', 'application/json');
    }
} 