<?php

namespace App\Middleware;

use Psr\Http\Message\ResponseFactoryInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;

class AuthMiddleware implements MiddlewareInterface
{
    private ResponseFactoryInterface $responseFactory;

    public function __construct(ResponseFactoryInterface $responseFactory)
    {
        $this->responseFactory = $responseFactory;
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        // Get the client's IP address
        $ipAddress = $request->getServerParams()['REMOTE_ADDR'] ?? '';

        // Allow only localhost and server IPs
        $allowedIps = ['127.0.0.1', '::1', 'your-server-ip']; // Replace 'your-server-ip' with your actual server IP

        if (!in_array($ipAddress, $allowedIps)) {
            // Unauthorized access: create a 403 Forbidden response
            $response = $this->responseFactory->createResponse(403);
            $response->getBody()->write(json_encode([
                'error' => 'Unauthorized',
                'message' => 'Access denied.',
            ]));

            return $response->withHeader('Content-Type', 'application/json');
        }

        // If the IP is allowed, proceed with the next middleware
        return $handler->handle($request);
    }
}