<?php

namespace App\Traits;

use Psr\Http\Message\ResponseInterface as Response;

trait RespondsWithJson
{
    protected function jsonResponse(Response $response, array $data, int $status = 200): Response
    {
        $response->getBody()->write(json_encode($data));
        return $response
            ->withHeader('Content-Type', 'application/json')
            ->withStatus($status);
    }

    protected function errorResponse(Response $response, string $message, int $status): Response
    {
        return $this->jsonResponse($response, [
            'success' => false,
            'error' => $message
        ], $status);
    }
} 