<?php

namespace App\Traits;

trait SensitiveDataFilter
{
    private array $defaultSensitiveFields = [
        'absolute_path',
        'backend_path',
        'component_id',
        'password',
        'captcha_token',
        'token',
        'key',
        'secret',
        'auth',
        'confirm_password',
        'confirm_secret'
    ];

    protected array $sensitiveFields = [];

    protected function removeSensitiveData(array $data): array
    {
        $fieldsToRemove = array_unique(
            array_merge($this->defaultSensitiveFields, $this->sensitiveFields)
        );
        
        return array_diff_key($data, array_flip($fieldsToRemove));
    }
} 