<?php
use Psr\Http\Message\ServerRequestInterface as Request;

if (!function_exists('getComponentBackendPath')) {
    function getComponentBackendPath(string $serverRoot, string $pagePath, string $backendPath): string
    {
        $path = $serverRoot . '/' . trim($pagePath . '/' . $backendPath, '/');
        
        return is_dir($path) ? $path : throw new \Exception("Component Backend directory not found: $path");
    }
}

if (!function_exists('requireBackendFile')) {
    function requireBackendFile(Request $request, string $fileName)
    {
        $data = $request->getParsedBody();

        $path = getComponentBackendPath(
            $request->getAttribute('serverRoot'),
            $data['absolute_path'],
            $data['backend_path']
        );

        $filePath = $path . '/' . $fileName;

        if (!file_exists($filePath)) {
            throw new \Exception("Component config file not found: $filePath");
        }
        
        return require $filePath;
    }
}