<?php
// Define required PHP version
$requiredVersion = '8.1.0';
$currentVersion = PHP_VERSION;
$isCompatible = version_compare($currentVersion, $requiredVersion, '>=');

// Detect AJAX or Fetch request
$isAjax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
$isJsonRequest = isset($_SERVER['HTTP_ACCEPT']) && strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false;

if ($isAjax || $isJsonRequest) {
    // Return JSON response
    header('Content-Type: application/json');
    echo json_encode([
        'requiredVersion' => $requiredVersion,
        'currentVersion' => $currentVersion,
        'isCompatible' => $isCompatible,
        'message' => 
            $isCompatible
                ? "Compatible! Your PHP version ($currentVersion) meets the requirements ($requiredVersion)."
                : "Not Compatible! Please upgrade your PHP version. Current version: $currentVersion. Required version: $requiredVersion."
    ]);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP Version Check</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center p-4">
    <div class="bg-white rounded-lg shadow-lg p-8 max-w-md w-full">
        <h1 class="text-2xl font-bold text-gray-800 mb-6">PHP Version Checker</h1>
        
        <div class="space-y-4">
            <div class="border-b pb-4">
                <p class="text-gray-600">Required PHP Version:</p>
                <p class="text-lg font-semibold text-gray-800"><?php echo $requiredVersion; ?></p>
            </div>

            <div class="border-b pb-4">
                <p class="text-gray-600">Your PHP Version:</p>
                <p class="text-lg font-semibold text-gray-800"><?php echo $currentVersion; ?></p>
            </div>

            <div class="pt-4">
                <p class="text-gray-600">Status:</p>
                <?php if ($isCompatible): ?>
                    <div class="mt-2 bg-green-100 text-green-700 px-4 py-2 rounded-md flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span class="font-medium">Compatible! Your PHP version meets the requirements.</span>
                    </div>
                <?php else: ?>
                    <div class="mt-2 bg-red-100 text-red-700 px-4 py-2 rounded-md flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                        </svg>
                        <span class="font-medium">Not Compatible! Please upgrade your PHP version.</span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>