<?php

namespace App\Middleware;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Server\RequestHandlerInterface as RequestHandler;
use Psr\Http\Message\ResponseInterface;
use Psr\Container\ContainerInterface;

class ContainerValuesMiddleware
{
    private ContainerInterface $container;

    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    public function __invoke(Request $request, RequestHandler $handler): ResponseInterface
    {
        $request = $request
            ->withAttribute('serverRoot', $this->container->get('serverRoot'))
            ->withAttribute('siteRoot', $this->container->get('siteRoot'));
        
        return $handler->handle($request);
    }
} 