document.addEventListener("alpine:init", () => {
    Alpine.data("lightbox", () => ({
        open: false,

        init() {
            // close on escape key
            document.addEventListener("keydown", (e) => {
                if (e.key === "Escape") {
                    this.open = false;
                }
            });
        },

        trigger: {
            ["@click"]() {
                this.open = !this.open;
            },
        },

        overlay: {
            ["x-show"]() {
                return this.open;
            },
        },
    }));
});
