document.addEventListener("alpine:init", () => {
    Alpine.data("mp4", (options = {}) => ({
        options: {
            muted: false,
            autoplay: false,
            controls: true,
            loop: false,
            ...options,
        },
        player: null,
        isPlaying: false,

        init() {
            this.player = this.$refs.player;

            this.player.addEventListener("play", () => {
                this.isPlaying = true;
            });

            this.player.addEventListener("pause", () => {
                this.isPlaying = false;
            });
        },

        play() {
            if (this.player && !this.isPlaying) this.player.play();
        },

        stop() {
            if (this.player) this.player.pause();
        },
    }));
});
