<?php

declare(strict_types=1);

use App\Classes\Email;
use App\Classes\WebhookClient;
use App\Controllers\FormEmailController;
use Psr\Container\ContainerInterface;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Psr\Log\LoggerInterface;
use App\Classes\Config;
use Monolog\Level;
use DI\ContainerBuilder;
use App\Controllers\WebhookController;

return [
    LoggerInterface::class => function() {
        $logger = new Logger('app');
        $logger->pushHandler(new StreamHandler(
            dirname(__DIR__) . '/logs/app.log',
            Level::Debug
        ));
        return $logger;
    },
    WebhookController::class => function(ContainerInterface $container) {
        return new WebhookController(
            $container->get(LoggerInterface::class),
            $container->get(WebhookClient::class)
        );
    },
];
