<?php

declare(strict_types=1);

// turn on error reporting
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

use DI\ContainerBuilder;
use Slim\Factory\AppFactory;
use Psr\Log\LoggerInterface;
use App\Handlers\HttpErrorHandler;

require __DIR__ . '/../vendor/autoload.php';

// Create Container Builder
$containerBuilder = new ContainerBuilder();

// Add definitions
$containerBuilder->addDefinitions(__DIR__ . '/../config/definitions.php');

// Build Container
$container = $containerBuilder->build();

// Web-accessible path
$container->set('siteRoot', function () {
    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
    $scriptDirParts = explode('rw', $scriptDir);
    return $scriptDirParts[0];
});

// Full server filesystem path
$container->set('serverRoot', function () {
    $scriptDir = dirname($_SERVER['SCRIPT_FILENAME']);
    $scriptDirParts = explode('rw', $scriptDir);
    return $scriptDirParts[0];
});


// Create App with container
$app = AppFactory::createFromContainer($container);

// Get the current directory name relative to document root
$scriptDir = dirname($_SERVER['SCRIPT_NAME']);

// Calculate base path by removing '/public' from the script path
$basePath = rtrim(
    str_replace(
        ['/public', '//'], 
        ['', '/'], 
        dirname($_SERVER['SCRIPT_NAME'])
    ),
    '/'
);

// Set the base path
$app->setBasePath($basePath);

// Add middleware
$app->addBodyParsingMiddleware();
$app->add(new \App\Middleware\ContainerValuesMiddleware($container));

// Add Error Handling
$displayErrorDetails = true; // Set to false in production
$errorMiddleware = $app->addErrorMiddleware($displayErrorDetails, true, true);
$errorMiddleware->setDefaultErrorHandler(
    new HttpErrorHandler(
        $app->getCallableResolver(),
        $app->getResponseFactory(),
        $container->get(LoggerInterface::class),
        $displayErrorDetails
    )
);

// Register routes
require __DIR__ . '/../src/routes.php';

// Register functions
require __DIR__ . '/../src/functions.php';

$app->run();
