<?php

namespace App\Services;

use App\Interfaces\CaptchaVerifierInterface;
use GuzzleHttp\Client;

class RecaptchaVerifier implements CaptchaVerifierInterface
{
    private string $secretKey;
    private string $siteKey;

    public function __construct(string $secretKey, string $siteKey)
    {
        $this->secretKey = $secretKey;
        $this->siteKey = $siteKey;
    }

    public function verify(string $token): array
    {
        $client = new Client();
        $response = $client->post('https://www.google.com/recaptcha/api/siteverify', [
            'form_params' => [
                'secret' => $this->secretKey,
                'response' => $token
            ]
        ]);

        return json_decode($response->getBody(), true);
    }

    public function getClientScript(): string
    {
        return "https://www.google.com/recaptcha/api.js?render={$this->siteKey}";
    }

    public function getClientKey(): string
    {
        return $this->siteKey;
    }
} 