<?php

namespace App\Services;

use App\Interfaces\CaptchaVerifierInterface;
use GuzzleHttp\Client;

class TurnstileVerifier implements CaptchaVerifierInterface
{
    private string $secretKey;
    private string $siteKey;

    public function __construct(string $secretKey, string $siteKey)
    {
        $this->secretKey = $secretKey;
        $this->siteKey = $siteKey;
    }

    public function verify(string $token): array
    {
        $client = new Client();
        $response = $client->post('https://challenges.cloudflare.com/turnstile/v0/siteverify', [
            'form_params' => [
                'secret' => $this->secretKey,
                'response' => $token
            ]
        ]);

        $result = json_decode($response->getBody(), true);
        
        // Normalize response to match reCAPTCHA format
        return [
            'success' => $result['success'],
            'score' => $result['success'] ? 1 : 0, // Turnstile doesn't have scores
            'action' => $result['action'] ?? null,
            'hostname' => $result['hostname'] ?? null,
            'error-codes' => $result['error-codes'] ?? []
        ];
    }

    public function getClientScript(): string
    {
        return "https://challenges.cloudflare.com/turnstile/v0/api.js";
    }

    public function getClientKey(): string
    {
        return $this->siteKey;
    }
} 