<?php

use App\Controllers\FormEmailController;
use App\Controllers\WebhookController;
use App\Middleware\ComponentValidationMiddleware;
use Slim\Routing\RouteCollectorProxy as Group;
use App\Middleware\CaptchaMiddleware;

$app->group('/', function (Group $group) {
    $group->post('webhook', [WebhookController::class, 'create'])
          ->add(new CaptchaMiddleware());
    $group->post('email', [FormEmailController::class, 'create'])
          ->add(new CaptchaMiddleware());
})->add(ComponentValidationMiddleware::class);

